﻿Imports System.Net.Sockets
Imports MBNCSUtil
Imports System.Environment
Imports System.Text
Public Class clsBNCS
    Public Sub ParseBNCS(ByVal bytData() As Byte)
        If bytData(0) <> &H0 Then
            Dim packet As New BncsReader(bytData)
            Dim packetID As Byte

            packetID = packet.PacketID

            Select Case packetID
                Case &H50
                    recv_SID_AUTH_INFO(bytData)
                Case &H51
                    recv_SID_AUTH_CHECK(bytData)
                Case &H3A
                    recv_SID_LOGONRESPONSE2(bytData)
                Case &HF
                    recv_SID_CHATEVENT(bytData)
                Case &HA
                    recv_SID_ENTERCHAT(bytData)
            End Select
        End If
    End Sub
    Public Sub recv_SID_ENTERCHAT(ByVal bytData() As Byte)
        Dim packet As New BncsReader(bytData)

        UniqueName = packet.ReadCString

    End Sub
    Public Sub recv_SID_AUTH_CHECK(ByVal bytData() As Byte)
        Dim packet As New BncsReader(bytData)

        Dim result As Integer
        Dim keyUser As String
        Dim del As New doDel(AddressOf AddChatInvoke)

        result = packet.ReadInt32()

        Select Case result
            Case &H0
                AddChatText = "(BNET) Version and CD-Key check passed!"
                AddChatColor = Color.SpringGreen
                form.Invoke(del)
                send_SID_LOGONRESPONSE2()
            Case &H100
                AddChatText = "(BNET) Old game version."
                AddChatColor = Color.IndianRed
                form.Invoke(del)
            Case &H101
                AddChatText = "(BNET) Invalid version."
                AddChatColor = Color.IndianRed
                form.Invoke(del)
            Case &H102
                AddChatText = "(BNET) Game version must be downgraded."
                AddChatColor = Color.IndianRed
                form.Invoke(del)
            Case &H200
                AddChatText = "(BNET) Invalid CD-Key."
                AddChatColor = Color.IndianRed
                form.Invoke(del)
            Case &H201
                keyUser = packet.ReadCString
                AddChatText = "(BNET) CD-Key in use by: " & keyUser
                AddChatColor = Color.IndianRed
                form.Invoke(del)
            Case &H202
                AddChatText = "(BNET) Your CD-Key is banned."
                AddChatColor = Color.IndianRed
                form.Invoke(del)
            Case &H203
                AddChatText = "Wrong production information."
                AddChatColor = Color.IndianRed
                form.Invoke(del)
        End Select



    End Sub
    Public Sub send_SID_AUTH_INFO()
        Dim packet As New BncsPacket(&H50)

        packet.InsertInt32(0)
        packet.InsertDwordString("IX86")
        packet.InsertDwordString("W2BN")
        packet.InsertInt32(&H4F)
        packet.InsertInt32(&H0)
        packet.InsertInt32(&H0)
        packet.InsertInt32(&H0)
        packet.InsertInt32(&H0)
        packet.InsertInt32(&H0)
        packet.InsertCString("USA")
        packet.InsertCString("United States")

        Dim buff(packet.Count - 1) As Byte
        buff = packet.GetData
        sock.Send(buff, 0, buff.Length, SocketFlags.None)

    End Sub
    Public Sub recv_SID_AUTH_INFO(ByVal bytData() As Byte)
        Dim packet As New BncsReader(bytData)

        Dim logonType As Integer
        Dim UDPValue As Integer
        Dim Filetime As Long

        logonType = packet.ReadInt32
        ServerToken = packet.ReadInt32
        UDPValue = packet.ReadInt32
        Filetime = packet.ReadInt64
        Filename = packet.ReadCString
        ValueString = packet.ReadNullTerminatedByteArray

        send_SID_AUTH_CHECK()

    End Sub
    Public Sub send_SID_LOGONRESPONSE2()

        Dim del As New doDel(AddressOf LOGONRESPONSE2Invoke)
        form.Invoke(del)

    End Sub
    Public Sub LOGONRESPONSE2Invoke()

        Dim packet As New BncsPacket(&H3A)
        Dim passHash() As Byte
        Dim data() As Byte

        packet.InsertInt32(ClientToken)
        packet.InsertInt32(ServerToken)

        passHash = OldAuth.DoubleHashPassword(Password, ClientToken, ServerToken)

        packet.InsertByteArray(passHash)
        packet.InsertCString(Username)

        Dim del As New doDel(AddressOf AddChatInvoke)

        AddChatText = "(BOT) Sending login request..."
        AddChatColor = Color.Cornsilk

        form.Invoke(del)

        Data = packet.GetData()

        sock.Send(Data, Data.Length, SocketFlags.None)
    End Sub
    Public Sub CHATEVENTInvoke()
        Dim packet As New BncsReader(bData)

        Dim EventID As Integer
        Dim Flags As Integer
        Dim Ping As Integer
        Dim user As String
        Dim Text As String

        EventID = packet.ReadInt32
        Flags = packet.ReadInt32
        Ping = packet.ReadInt32
        packet.Seek(12)
        user = packet.ReadCString
        Text = packet.ReadCString

        Select Case EventID
            Case &H1
                With form.lvChannel.Items.Add(user)
                    .SubItems.Add(Convert.ToString(Ping) & "ms")
                End With
                form.lvChannel.Columns(1).Text = form.lvChannel.Items.Count
            Case &H2
                With form.lvChannel.Items.Add(user)
                    .SubItems.Add(Convert.ToString(Ping) & "ms")
                End With
                AddChat(Color.SpringGreen, " -- " & user & " has joined the channel.")
                form.lvChannel.Columns(1).Text = form.lvChannel.Items.Count
            Case &H3
                form.lvChannel.FindItemWithText(user).Remove()
                AddChat(Color.IndianRed, " -- " & user & " has left the channel.")
            Case &H4
                AddChat(Color.SpringGreen, "(From: " & user & "): ", Color.White, Text)
            Case &H5
                AddChat(Color.AliceBlue, "<" & user & "> ", Color.White, Text)
            Case &H6
                AddChat(Color.AliceBlue, "Server Broadcast: " & Text)
            Case &H7
                form.lvChannel.Items.Clear()
                AddChat(Color.Cornsilk, "Joined Channel: ", Color.White, Text)
                form.lvChannel.Columns(0).Text = Text
            Case &H9
                AddChat(Color.Cornsilk, " -- " & user & "'s flags are now: " & Flags)
            Case &HA
                AddChat(Color.SpringGreen, "(To: " & user & "): ", Color.White, Text)
            Case &HD
                AddChat(Color.IndianRed, "(BNET) Channel is full.")
            Case &HE
                AddChat(Color.IndianRed, "(BNET) Channel does not exist.")
            Case &HF
                AddChat(Color.IndianRed, "(BNET) Channel is restricted.")
            Case &H12
                AddChat(Color.Cornsilk, "(BNET) " & Text)
            Case &H13
                AddChat(Color.IndianRed, "(BNET) " & Text)
            Case &H17
                AddChat(Color.Cornsilk, user & " " & Text)
        End Select

        Erase bData

    End Sub
    Public Sub recv_SID_CHATEVENT(ByVal bytData() As Byte)
        Dim del As New doDel(AddressOf CHATEVENTInvoke)
        bData = bytData

        form.Invoke(del)


    End Sub
    Public Sub recv_SID_LOGONRESPONSE2(ByVal bytData() As Byte)
        Dim result As Integer
        Dim packet As New BncsReader(bytData)
        Dim del As New doDel(AddressOf AddChatInvoke)

        result = packet.ReadInt32

        Select Case result
            Case &H0
                AddChatText = "(BNET) Successfully logged in as " & Username & "!"
                AddChatColor = Color.SpringGreen
                send_SID_ENTERCHAT()
                send_SID_JOINCHANNEL()
            Case &H1
                AddChatText = "(BNET) Account doesn't exist."
                AddChatColor = Color.IndianRed
            Case &H2
                AddChatText = "(BNET) Invalid password."
                AddChatColor = Color.IndianRed
            Case &H6
                AddChatText = "(BNET) Account is banned!"
                AddChatColor = Color.IndianRed
        End Select

        form.Invoke(del)



    End Sub
    Public Sub send_SID_ENTERCHAT()
        Dim packet As New BncsPacket(&HA)
        Dim data() As Byte

        packet.InsertCString(Username)
        packet.InsertCString("")

        data = packet.GetData()

        sock.Send(data, data.Length, SocketFlags.None)
    End Sub
    Public Sub send_SID_JOINCHANNEL()
        Dim packet As New BncsPacket(&HC)
        Dim data() As Byte

        packet.InsertInt32(&H2)
        packet.InsertCString(HomeChannel)

        data = packet.GetData

        sock.Send(data, data.Length, SocketFlags.None)

    End Sub
    Public Sub send_SID_CHATCOMMAND(ByVal strChat As String)
        Dim packet As New BncsPacket(&HE)
        Dim data() As Byte

        packet.InsertCString(strChat)

        data = packet.GetData()

        sock.Send(data, data.Length, SocketFlags.None)
    End Sub
    Public Sub send_SID_AUTH_CHECK()
        ClientToken = TickCount

        'Invoke and run the LockdownCR on the main Form.
        Dim del As New doDel(AddressOf DoLockDownCheckRevision)
        form.Invoke(del)

    End Sub
    Public Sub DoLockDownCheckRevision()
        Dim gamefiles(2) As String
        Dim rReturn(1024) As Byte
        Dim cdHash(1024) As Byte
        Dim packet As New BncsPacket(&H51)

        gamefiles(0) = Application.StartupPath & "\Hashes\W2BN\WarCraft II BNE.exe"
        gamefiles(1) = Application.StartupPath & "\Hashes\W2BN\storm.dll"
        gamefiles(2) = Application.StartupPath & "\Hashes\W2BN\battle.snp"

        rReturn = CheckRevision.DoLockdownCheckRevision(ValueString, gamefiles, Application.StartupPath & "\lockdown\" & Replace(Filename, ".mpq", ".dll"), Application.StartupPath & "\Hashes\w2bn.bin", Version, CheckSum)


        packet.InsertInt32(ClientToken)
        packet.InsertInt32(Version)
        packet.InsertInt32(CheckSum)
        packet.InsertInt32(&H1)
        packet.InsertInt32(&H0)

        'For each key:
        'Key 1
        Dim prodID As Integer
        Dim pubValue As Integer
        Try

            If CdKey.CreateDecoder(myCDKey).IsValid = False Or myCDKey.Length <= 1 Then
                AddChat(Color.IndianRed, "(BOT) Your CD-Key is invalid, please insert a new CD-Key.")
                sock.Disconnect(True)
                Exit Sub
            End If

            cdHash = CdKey.CreateDecoder(myCDKey).GetHash(ClientToken, ServerToken)
            prodID = CdKey.CreateDecoder(myCDKey).Product
            pubValue = CdKey.CreateDecoder(myCDKey).Value1

            packet.InsertInt32(myCDKey.Length)
            packet.InsertInt32(prodID)
            packet.InsertInt32(pubValue)
            packet.InsertInt32(&H0)
            packet.InsertByteArray(cdHash)
            packet.InsertByteArray(rReturn)
            packet.InsertByte(&H0)
            packet.InsertCString("Midnight Chat.NET")

            Dim buff(1024) As Byte

            buff = packet.GetData()

            AddChat(Color.Cornsilk, "(BNET) Sending version check information...")

            sock.Send(buff, packet.Count, SocketFlags.None)
        Catch ex As Exception
            AddChat(Color.IndianRed, "(BOT) Problem sending SID_AUTH_CHECK.  This could be caused by you not entering a CD-Key into your config.")
        End Try
    End Sub
End Class
